"""
Ran 1000 samples 10x to show STD
"""

import numpy as np

x1 = [
    0.4999062094294668,
    0.49934905537993274,
    0.4995161097763148,
    0.4997857843612706,
    0.4999155270305704,
    0.49975204244492194,
    0.4996839043760176,
    0.4999595323163457,
    0.49933945567253324,
    0.49953634219434545
]

# 4q 5L 3g s=250
x2 = [
    1.8523511746256853,
    1.8498826725573956,
    1.7666526803083482,
    1.781313599631199,
    1.7561211072400749,
    1.7711341661367288,
    1.8894269989283317,
    1.8079430275692008,
    1.8190297552512456,
    1.7684564075941052,
    1.7242776636810209,
    1.7223432624063773,
    1.7001302386545425,
    1.832792255953797,
    1.7466318814555208,
    1.7560686110518273,
    1.7787099012069219,
    1.8163576378923827,
    1.8725353261351263,
    1.70045604132345,
    1.7063130095669115,
    1.807564483205849,
    1.8699567832463364,
    1.733023701702139,
    1.779524092699843,
    1.720335862843743,
    1.8188734774063002,
    1.686467609935218,
    1.7517743044723688,
    1.78386790770166,
    1.7936326191957466,
    1.8409446598878223,
    1.7154878792937587,
    1.7132596118558319,
    1.8292231427411916,
    1.7154430099288351,
    1.6820482574152327,
    1.7138365912188942,
    1.732138401696781,
    1.8203167771928263,
    1.6661252712098287,
    1.747403888893713,
    1.6867291798394755,
    1.8853984531842698,
    1.8003167771928263,
    1.752633850364189,
    1.796943798729837,
    1.8236174608023032,
    1.7034014976316312,
    1.8272792377977765,
    #1.766380728812801
]

x3 = [
    3.1503145477382013,
    3.07422778104954,
    3.1528630855574176,
    3.17067410530012,
    3.152030229830223,
    3.2093005533732835,
    3.1962446892808436,
    3.2284116501447753,
    3.06668058998565,
    3.146825442546906,
    3.1235523593456254,
    3.081226855063371,
    3.148018578297082,
    3.227684830303067,
    3.0788319615599864,
    3.2160205375034794,
    3.095821674254238,
    3.2717985750452443,
    3.144056129786338,
    3.2334404932305647,
    3.266175639929855,
    3.094726141111554,
    3.1874913216158403,
    3.1343787639263807,
    3.18747560445007,
    3.169763958057894,
    3.16318963237763,
    3.170995775509595,
    3.1249391956844694,
    3.184021752271728,
    3.173027788556377,
    3.062623370337259,
    3.240254788025804,
    3.0876927452201706,
    3.1795931785628633,
    3.17201460519422,
    3.124478140012997,
    3.089701607741366,
3.1886651269325093,
3.1581377839291087,
3.2298756547160026,
3.129455677944446,
3.1202053488849386,
3.1977490031658693,
3.215683453542765,
3.094196612094036]

X1 = x1
X2 = [max(x2[i:i+5]) for i in range(0, len(x2), 5)]
X3 = [max(x3[i:i+5]) for i in range(0, len(x3), 5)]

print(len(X1),X1,len(X2),X2,len(X3),X3)

import matplotlib.pyplot as plt
import numpy as np

lmax_p12 = [0.4999062094294668, 0.49934905537993274, 0.4995161097763148, 0.4997857843612706, 0.4999155270305704,
            0.49975204244492194, 0.4996839043760176, 0.4999595323163457, 0.49933945567253324, 0.49953634219434545]
lmax_p60 = [1.8523511746256853, 1.8894269989283317, 1.832792255953797, 1.8725353261351263, 1.8699567832463364,
            1.8188734774063002, 1.8409446598878223, 1.8203167771928264, 1.8853984531842698, 1.8272792377977765]
lmax_p120 = [3.17067410530012, 3.2284116501447753, 3.227684830303067, 3.2717985750452443, 3.266175639929855,
             3.184021752271728, 3.240254788025804, 3.1886651269325093, 3.2298756547160026, 3.094196612094036]

data = [lmax_p12, lmax_p60, lmax_p120]
means = [np.mean(d) for d in data]
stds = [np.std(d) for d in data]

print("Calculated Standard Deviations (σ):")
print(f"P=12: {means[0]:.5f} {stds[0]:.5f}")
print(f"P=60: {means[1]:.5f} {stds[1]:.5f}")
print(f"P=120: {means[2]:.5f} {stds[2]:.5f}")

labels = ['P=12 (1 Layer)', 'P=60 (5 Layers)', 'P=120 (10 Layers)']
colors = ['#4c72b0', '#55a868', '#c44e52']

plt.style.use('seaborn-v0_8-whitegrid')
fig, ax = plt.subplots(figsize=(8, 6))
ax.set_facecolor('gainsboro')

bars = ax.bar(labels, means, yerr=stds,
              capsize=8,
              color=colors,
              edgecolor='black',
              alpha=0.8,
              ecolor='black',
              )

ax.set_ylabel('Mean $\\tilde{L}_{max}$', fontsize=20)
ax.set_xlabel('Circuit Depth (Number of Parameters)', fontsize=18)
ax.set_ylim(0, max(means) * 1.25)
for i, bar in enumerate(bars):
    yval = bar.get_height()
    std_val = stds[i]
    text_position = yval + std_val + 0.03

    ax.text(bar.get_x() + bar.get_width() / 2.0, text_position,
            f'σ = {std_val:.4f}',
            ha='center', va='bottom',
            fontsize=14,
            fontweight='bold',
            color='#333333')

# --- 7. Display the Plot ---
ax.tick_params(labelsize=16)
plt.tight_layout() 
plt.show()
